Object.defineProperty(exports, "__esModule", { value: true });
var child_process_1 = require("child_process");
var debug = require("debug");
var helpers_1 = require("./helpers");
var d = debug('electron-notarize:spawn');
exports.spawn = function (cmd, args, opts) {
    if (args === void 0) { args = []; }
    if (opts === void 0) { opts = {}; }
    d('spawning cmd:', cmd, 'args:', args.map(function (arg) { return helpers_1.isSecret(arg) ? '*********' : arg; }), 'opts:', opts);
    var child = child_process_1.spawn(cmd, args, opts);
    var out = [];
    var dataHandler = function (data) { return out.push(data.toString()); };
    child.stdout.on('data', dataHandler);
    child.stderr.on('data', dataHandler);
    return new Promise(function (resolve) {
        child.on('exit', function (code) {
            d("cmd " + cmd + " terminated with code: " + code);
            resolve({
                code: code,
                output: out.join(''),
            });
        });
    });
};
//# sourceMappingURL=spawn.js.map