import Vue from 'vue'
import Vuex from 'vuex'
import { pageComponents } from "./page_components.js"
import { state, getters, mutations, actions } from "./app_store.js"
import { auth } from "./auth.js"
import { sms } from "./sms.js"
import { grupos } from "./grupos.js"
import { contacto } from "./contacto.js"
import { user } from "./user.js"
import { roles } from "./roles.js"
import { permissions } from "./permissions.js"
Vue.use(Vuex)
export default function (/* { ssrContext } */) {
	const Store = new Vuex.Store({
		state,
		getters,
		mutations,
		actions,
		modules: {
			pageComponents,
			auth,
		sms,
		grupos,
		contacto,
		user,
		roles,
		permissions
		},
		// enable strict mode (adds overhead!)
		// for dev mode only
		strict: process.env.DEV
	})
	return Store
}