/** Express router providing related routes to page component data
 * @module routers/components_data
 * @requires express
 * @requires config - app config
 * @requires models- app model module
 */


 /**
 * express module
 * @const
 */
const express = require('express');


/**
 * Express router to mount user page functions.
 * @type {object}
 * @const
 */
const router = express.Router();


/**
 * App config module
 * @const
 */
const config = require('../config.js');


/**
 *  models
 * @const
 */
const models = require('../models/index.js');


const sequelize = models.sequelize;
const Op = models.Op; // sequelize query operators


 /**
 * Route to get id_grupo_option_list records
 * @route {GET} /components_data/id_grupo_option_list
 * @param {string} path - Express paths
 * @param {callback} middleware - Express middleware.
 */
router.get('/id_grupo_option_list', async (req, res) => {
	try{
		let sqltext = `SELECT  DISTINCT id AS value,nome AS label FROM grupos ORDER BY nome` ;
		let queryParams = {};
		queryParams['lookup_id_user'] = req.query.lookup_id_user;
		let records = await sequelize.query(sqltext, {replacements: queryParams, type: sequelize.QueryTypes.SELECT });
		return res.ok(records);
	}
	catch(err){
		console.error(err)
		return res.serverError(err);
	}
});


 /**
 * Route to check if field value already exist in a User table
 * @route {GET} /components_data/user_name_exist/{fieldvalue}
 * @param {string} path - Express paths
 * @param {callback} middleware - Express middleware.
 */
router.get('/user_name_exist/:fieldvalue', async (req, res) => {
	try{
		let val = req.params.fieldvalue
		let count = await models.User.count({ where:{ 'name': val } });
		if(count > 0){
			return res.ok("true");
		}
		return res.ok("false");
	}
	catch(err){
		return res.serverError(err);
	}
});


 /**
 * Route to check if field value already exist in a User table
 * @route {GET} /components_data/user_email_exist/{fieldvalue}
 * @param {string} path - Express paths
 * @param {callback} middleware - Express middleware.
 */
router.get('/user_email_exist/:fieldvalue', async (req, res) => {
	try{
		let val = req.params.fieldvalue
		let count = await models.User.count({ where:{ 'email': val } });
		if(count > 0){
			return res.ok("true");
		}
		return res.ok("false");
	}
	catch(err){
		return res.serverError(err);
	}
});


 /**
 * Route to get user_role_id_option_list records
 * @route {GET} /components_data/user_role_id_option_list
 * @param {string} path - Express paths
 * @param {callback} middleware - Express middleware.
 */
router.get('/user_role_id_option_list', async (req, res) => {
	try{
		let sqltext = `SELECT role_id AS value, role_name AS label FROM roles` ;
		let records = await sequelize.query(sqltext, { type: sequelize.QueryTypes.SELECT });
		return res.ok(records);
	}
	catch(err){
		console.error(err)
		return res.serverError(err);
	}
});


 /**
 * Route to getcount_grupos value
 * @route {GET} /components_data/getcount_grupos
 * @param {string} path - Express paths
 * @param {callback} middleware - Express middleware.
 */
router.get('/getcount_grupos', async (req, res) => {
	try{
		let sqltext = `SELECT COUNT(*) AS num FROM grupos` ;
		let records = await sequelize.query(sqltext, { type: sequelize.QueryTypes.SELECT });
		let val = Object.values(records[0])[0].toString();
		return res.ok(val);
	}
	catch(err){
		console.error(err)
		return res.serverError(err);
	}
});


 /**
 * Route to getcount_contacto value
 * @route {GET} /components_data/getcount_contacto
 * @param {string} path - Express paths
 * @param {callback} middleware - Express middleware.
 */
router.get('/getcount_contacto', async (req, res) => {
	try{
		let sqltext = `SELECT COUNT(*) AS num FROM contacto` ;
		let records = await sequelize.query(sqltext, { type: sequelize.QueryTypes.SELECT });
		let val = Object.values(records[0])[0].toString();
		return res.ok(val);
	}
	catch(err){
		console.error(err)
		return res.serverError(err);
	}
});


 /**
 * Route to getcount_sms value
 * @route {GET} /components_data/getcount_sms
 * @param {string} path - Express paths
 * @param {callback} middleware - Express middleware.
 */
router.get('/getcount_sms', async (req, res) => {
	try{
		let sqltext = `SELECT COUNT(*) AS num FROM sms` ;
		let records = await sequelize.query(sqltext, { type: sequelize.QueryTypes.SELECT });
		let val = Object.values(records[0])[0].toString();
		return res.ok(val);
	}
	catch(err){
		console.error(err)
		return res.serverError(err);
	}
});
module.exports = router;
