
const BaseModel = require("./basemodel");
class Contacto extends BaseModel {
	static init(sequelize, Sequelize) {
		return super.init(
			{
				
				id: { type: Sequelize.INTEGER, primaryKey: true , autoIncrement: true },
				nome: {name: 'nome', type:Sequelize.STRING},
				telefone: {name: 'telefone', type:Sequelize.STRING},
				date_created: {name: 'date_created', type:Sequelize.DATE},
				date_updated: {name: 'date_updated', type:Sequelize.DATE},
				id_user: {name: 'id_user', type:Sequelize.STRING},
				id_grupo: {name: 'id_grupo', type:Sequelize.STRING}
			}, 
			{ 
				sequelize,
				
				tableName: "contacto",
				modelName: "contacto",
			}
		);
	}
	
	static listFields() {
		let sequelize = this.sequelize;
		return [
			'id', 
			'nome', 
			'telefone', 
			'date_created', 
			'id_user', 
			sequelize.literal("grupos.id AS grupos_id"), 
			sequelize.literal("grupos.nome AS grupos_nome"), 
			sequelize.literal("grupos.id_user AS grupos_id_user")
		];
	}

	static exportListFields() {
		let sequelize = this.sequelize;
		return [
			'id', 
			'nome', 
			'telefone', 
			'date_created', 
			'id_user', 
			sequelize.literal("grupos.id AS grupos_id"), 
			sequelize.literal("grupos.nome AS grupos_nome"), 
			sequelize.literal("grupos.id_user AS grupos_id_user")
		];
	}

	static viewFields() {
		let sequelize = this.sequelize;
		return [
			'id', 
			'nome', 
			'telefone', 
			'date_created', 
			'date_updated', 
			'id_user', 
			'id_grupo', 
			sequelize.literal("grupos.id AS grupos_id"), 
			sequelize.literal("grupos.nome AS grupos_nome"), 
			sequelize.literal("grupos.date_created AS grupos_date_created"), 
			sequelize.literal("grupos.date_updated AS grupos_date_updated"), 
			sequelize.literal("grupos.id_user AS grupos_id_user")
		];
	}

	static exportViewFields() {
		let sequelize = this.sequelize;
		return [
			'id', 
			'nome', 
			'telefone', 
			'date_created', 
			'date_updated', 
			'id_user', 
			'id_grupo', 
			sequelize.literal("grupos.id AS grupos_id"), 
			sequelize.literal("grupos.nome AS grupos_nome"), 
			sequelize.literal("grupos.date_created AS grupos_date_created"), 
			sequelize.literal("grupos.date_updated AS grupos_date_updated"), 
			sequelize.literal("grupos.id_user AS grupos_id_user")
		];
	}

	static editFields() {
		let sequelize = this.sequelize;
		return [
			'id', 
			'nome', 
			'telefone', 
			'id_grupo'
		];
	}

	
	static searchFields(){
		let sequelize = this.sequelize;
		return [
			sequelize.literal("Contacto.nome LIKE :search"), 
			sequelize.literal("Contacto.telefone LIKE :search"), 
			sequelize.literal("Contacto.id_user LIKE :search"), 
			sequelize.literal("Contacto.id_grupo LIKE :search"), 
			sequelize.literal("Grupos.nome LIKE :search"), 
			sequelize.literal("Grupos.id_user LIKE :search"),
		];
	}

	
	
}
module.exports = Contacto;
