
const BaseModel = require("./basemodel");
class Grupos extends BaseModel {
	static init(sequelize, Sequelize) {
		return super.init(
			{
				
				id: { type: Sequelize.INTEGER, primaryKey: true , autoIncrement: true },
				nome: {name: 'nome', type:Sequelize.STRING},
				date_created: {name: 'date_created', type:Sequelize.DATE},
				date_updated: {name: 'date_updated', type:Sequelize.DATE},
				id_user: {name: 'id_user', type:Sequelize.STRING}
			}, 
			{ 
				sequelize,
				
				tableName: "grupos",
				modelName: "grupos",
			}
		);
	}
	
	static listFields() {
		let sequelize = this.sequelize;
		return [
			'id', 
			'nome', 
			'date_created', 
			'id_user'
		];
	}

	static exportListFields() {
		let sequelize = this.sequelize;
		return [
			'id', 
			'nome', 
			'date_created', 
			'id_user'
		];
	}

	static viewFields() {
		let sequelize = this.sequelize;
		return [
			'id', 
			'nome', 
			'date_created', 
			'date_updated', 
			'id_user'
		];
	}

	static exportViewFields() {
		let sequelize = this.sequelize;
		return [
			'id', 
			'nome', 
			'date_created', 
			'date_updated', 
			'id_user'
		];
	}

	static editFields() {
		let sequelize = this.sequelize;
		return [
			'id', 
			'nome'
		];
	}

	
	static searchFields(){
		let sequelize = this.sequelize;
		return [
			sequelize.literal("nome LIKE :search"), 
			sequelize.literal("id_user LIKE :search"),
		];
	}

	
	
}
module.exports = Grupos;
