
const BaseModel = require("./basemodel");
class Role_Permissions extends BaseModel {
	static init(sequelize, Sequelize) {
		return super.init(
			{
				
				permission_id: { type: Sequelize.INTEGER, primaryKey: true , autoIncrement: true },
				role_id: {name: 'role_id', type:Sequelize.INTEGER},
				page_name: {name: 'page_name', type:Sequelize.STRING},
				action_name: {name: 'action_name', type:Sequelize.STRING}
			}, 
			{ 
				sequelize,
				
				tableName: "role_permissions",
				modelName: "role_permissions",
			}
		);
	}
	
	static listFields() {
		let sequelize = this.sequelize;
		return [
			'permission_id', 
			'role_id', 
			'page_name', 
			'action_name'
		];
	}

	static exportListFields() {
		let sequelize = this.sequelize;
		return [
			'permission_id', 
			'role_id', 
			'page_name', 
			'action_name'
		];
	}

	static viewFields() {
		let sequelize = this.sequelize;
		return [
			'permission_id', 
			'role_id', 
			'page_name', 
			'action_name'
		];
	}

	static exportViewFields() {
		let sequelize = this.sequelize;
		return [
			'permission_id', 
			'role_id', 
			'page_name', 
			'action_name'
		];
	}

	static editFields() {
		let sequelize = this.sequelize;
		return [
			'permission_id', 
			'role_id', 
			'page_name', 
			'action_name'
		];
	}

	
	static searchFields(){
		let sequelize = this.sequelize;
		return [
			sequelize.literal("page_name LIKE :search"), 
			sequelize.literal("action_name LIKE :search"),
		];
	}

	
	
}
module.exports = Role_Permissions;
